/*
 *******************************************************
 application:		WSP Get
 author:		Ollie (ollie@atstake.com)
 version:		0.2
 known bugs &
 design issues:		
 			1) fixed buffers all over the place *
 			(only only left on the recive routine)

 to-do:
 			1) allow posting of data from stdin
 			
 			2) add null char to end of packet (nokia WAP GW needs it)
 			
 changlog:		
 			28-Nov-2001 - New length function patch supplied by srk@atstake.com
 			27-Nov-2001 - New oprint function patch supplied by srk@atstake.com
 			26-Nov-2001 - Fixed the munged post request issues (see 23rd changlog)
 			26-Nov-2001 - Fixed all bufferoverflows in the code except
 				      one in the IP recv() routine (which isn't really one)
 			23-Nov-2001 - Fixed packet length issues which resulted in
 				      random data from the stack being put in as the
 				      length.
 			??-Jul-2001 - Developed for the first time
 		
 WAP spec doc:		WAP-203-WSP-20000504-a.pdf
 
 gateways tested
 with:			Ericsson Enterprise Gateway 2.0
 			WAPLite 1.1 (SP1) & 2.0
 			WAPServ 1.0
 			Nokia's ActiveServ 
 			Kannel 1.0.3-1
 			Jataayu
 			Jataayu Enterprise WAP Server
			Jinny 1.1
			theMOBILIZER Secure WAP Gateway 2.4 (BL14.17)
			OpenWave
 *******************************************************
*/
#ifdef _WIN32
#include <Winsock2.h>
#include <Windows.h>
#define snprintf _snprintf
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdio.h>

/* functions */
void usage();
void oprint(char *bufdump,int buflen);

/* varibles */
unsigned char sc[11][10000]={
			   "\x01",	/* WSP connect */

			   /* Client compatibility options */
			   "\x80\x88", 	/* WSP options: Accept: text/vnd.wap.wml */
			   "\x80\x94", 	/* WSP options: Accept: application/vnd.wap.wmlc */
			   "\x80\xA1", 	/* WSP options: Accept: image/vnd.wap.wbmp */
			   "\x80\x9D", 	/* WSP options: Accept: image/gif */
			   "\x80\x9E", 	/* WSP options: Accept: image/jpeg */
			   "\x80\x89", 	/* WSP options: Accept: text/vnd.wap.wmlscript */
			   "\x80\x95", 	/* WSP options: Accept: application/vnd.wap.wmlscriptc */
		   
			   /* User Agent */
			   "\xA9",	/* WSP options: UserAgent */
			   "stake",
			   
			   "\x00",	/* Null */
			   };
/* end varibles */

/*
 *******************************************************
 Function: Main
 *******************************************************
*/
main (int argc, char *argv[])
{
	char rcvbuf[40000],*temp,*request_message,*reqtype,*bang,*reallen;
	int reqlen,X,sock,sp=0,rcvbufsize, packetlen;
	unsigned short serverport=htons(9200);
	struct hostent *nametocheck;
	struct sockaddr_in serv_addr;
	struct in_addr attack;
	
#ifdef _WIN32
	WORD werd;
	WSADATA wsd;
	werd= MAKEWORD(2,0);
	WSAStartup(werd,&wsd);
#endif

	/* app banner */
	printf("oo0 @stake wap pentesting tookit 0oo\n");
	printf("wspget - v0.2 \n");
	printf("author: ollie (ollie@atstake.com)\n");
	
	/* user supplied parameters */
	if(argc < 4) usage(); /* should be five to account for http get option */
	
	nametocheck = gethostbyname (argv[1]);
	memcpy(&attack.s_addr,nametocheck->h_addr_list[0],4);
	
	serverport=ntohs((unsigned short)atoi(argv[2]));
	
	if(argv[4] != NULL){
			reqtype=malloc(3);
		if(strcmp(argv[4],"get")==0){
			strcpy(reqtype,"\x40"); }
		else if(strcmp(argv[4],"options")==0){
			strcpy(reqtype,"\x41"); }
		else if(strcmp(argv[4],"head")==0){			
			strcpy(reqtype,"\x42"); }
		else if(strcmp(argv[4],"delete")==0){
			strcpy(reqtype,"\x43"); }
		else if(strcmp(argv[4],"trace")==0){
			strcpy(reqtype,"\x44"); }
		else if(strcmp(argv[4],"post")==0){
			strcpy(reqtype,"\x60"); }
		else if(strcmp(argv[4],"put")==0){
			strcpy(reqtype,"\x61"); }
		else {
			strcpy(reqtype,"\x40"); }
	}
	else {
			reqtype=malloc(3);
			strcpy(reqtype,"\x40"); }
	

	
	
	/* the length of the requested URI */
	reqlen = strlen(argv[3]);
	reallen=malloc(reqlen);
    	sprintf(reallen,"%d",reqlen);
    	
    	/* info message */
	printf("requesting URI: %s\ngateway: %s on port: %d via request type: %x\nrequest legnth: %s\n",argv[3],inet_ntoa(attack),htons(serverport),reqtype[0],reallen);
		
    	/*memset(bang,0x41,20000);
    	reqlen = strlen(bang); */
    	
    	
 	/* packet contents */
        packetlen=strlen(sc[0]) + strlen(reqtype) + strlen(reallen) + strlen(argv[3]) + strlen(sc[1]) + strlen(sc[2]) +strlen(sc[3]) + strlen(sc[4]) +strlen(sc[5]) +strlen(sc[6]) + strlen(sc[7]);
        request_message=malloc(packetlen);
        strcpy(request_message,sc[0]);
        strcat(request_message,reqtype);

	/* srk - length patch*/
	#if 0
        strcat(request_message,reallen);
	#endif
	{
        	int curlen = strlen(request_message);
        	request_message[curlen++] = reqlen & 0xff;
        	request_message[curlen++] = '\0';
	}
	/*!srk - length patch*/

        strcat(request_message,argv[3]);
        strcat(request_message,sc[1]);
        strcat(request_message,sc[2]);
        strcat(request_message,sc[3]);
        strcat(request_message,sc[4]);
        strcat(request_message,sc[5]);
        strcat(request_message,sc[6]);
        strcat(request_message,sc[7]);	
        
	/*
	This was taken out due to Nokia GW barfing because I didn't null
	terminate the packet..
	
	strcat(request_message,sc[8]);
	strcat(request_message,sc[9]);

	*/
		
	/* end of packet contents */

	/* ip stuff */
	sock = socket (AF_INET, SOCK_DGRAM, 0);
	memset (&serv_addr, 0, sizeof (serv_addr));
	serv_addr.sin_family=AF_INET;
	serv_addr.sin_addr.s_addr = attack.s_addr;
	serv_addr.sin_port = serverport;
	X=connect (sock, (struct sockaddr *) &serv_addr, sizeof (serv_addr));
	if(X==0)
	{
	 	
		printf("sent data to %s \n",inet_ntoa(attack));		
		send(sock,request_message,strlen(request_message)*sizeof(char),0);
		
		rcvbufsize = recv(sock, rcvbuf, 40000, 0);
		
		printf("recieved response\n.start\n");
		oprint(rcvbuf,rcvbufsize);
		printf("\n.end\n");
		
		printf("recieved length: %d\n",rcvbufsize);

	}
	else
	{
		printf("couldn't connect\n",inet_ntoa(attack));
	}
	

	
#ifdef _WIN32
	closesocket(sock); 
#else
	close(sock);
#endif
	return 0;
}


/*
 *******************************************************
 Function: Usage
 Role	 : Prints out help screen
 *******************************************************
*/
void usage()
{
	printf("\n");
	printf("WAP gateway 	  - required\n");
	printf("WAP server port   - required\n");
	printf("uri to teq	  - required\n");
	printf("http req type 	  - optional (defaults to get)\n\n");
	printf("syntax:	  wspget <wap gateway> <server port> <URL to request> <HTTP req type>\n");
	printf("example:  wspget 10.1.1.1 9200 http://wap.foo.com/ get\n");
	exit(1);
}

/*
 *******************************************************
 Function: oprint
 Role	 : hex dumps said buffer
 Takes	 : buffer and length
 Notes	 : names inspired by hobbits oprint from netcat
 *******************************************************
*/
void oprint(bufdump,buflen)
	int buflen;
	char bufdump[2000];
{
	int c=0,c2=0;
		
	while (c <= buflen)
	{
		if (c2==16)
		{
			c2=c - 16;
			while (c2<c)
			{
				if (bufdump[c2] > 31 && bufdump[c2]<127)
					printf("%c",bufdump[c2]);
				else
					printf(".");
				c2++;
			}
			printf("\n");
			c2=0;
		}
		printf("%0.2x",bufdump[c] & 0xff);
		printf(" ");
		c++;
		c2++;
	}

	if(c2 != 1)
	{
		while(c2 < 16)
		{
			printf("   ");
			c2++;
			c++;
		}
		c2 = c - 16;
		while(c2 <= buflen)
		{
			if (bufdump[c2] > 31 && bufdump[c2]<127)
				printf("%c",bufdump[c2]);
			else
				printf(".");
			c2++;
		}
	}

	return;
}
